(function ($) {
    function makeid(length) {
        let result = '';
        let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        let charactersLength = characters.length;
        for (let i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }
        return result;
    }
    const $urlApi = '//' + window.location.hostname + '/api/v1/';
    if ($('.cnpj_mask').length > 0) {
        $(".cnpj_mask").on("keyup", function (e) {
            $(this).val(
                $(this).val()
                    .replace(/\D/g, '')
                    .replace(/^(\d{2})(\d{3})?(\d{3})?(\d{4})?(\d{2})?/, "$1.$2.$3/$4-$5"));
        });
    }
    $(document).ready(function () {
        const currentPage = window.location.pathname;


        var captcha = makeid(5);
        $('.captcha').text(captcha);

        $('.main-menu').each(function () {
            if ($(this).attr('href') == currentPage) {
                $(this).closest('li').addClass('active');
            }
        });

        $(document).on('click', '.form-group', function () {
            $(this).closest('form').find('.alert').hide(100).prop('class', 'alert').text('');
        });

        $(document).on('input', '.input-error', function () {
            $(this).removeClass('input-error');
        });

        $(document).on('click', '.formSubmit', function () {
            let form = $(this).closest('form');
            let $result_field = form.find('.captcha_result');
            if (captcha != $result_field.val()) {
                $result_field.addClass('input-error');
            }

            form.find('[required]').each(function () {
                if (!$(this).val()) {
                    $(this).addClass('input-error');
                }
            });

            if (form.find('.input-error').length != 0) {
                validacao = false;
            } else {
                validacao = true;
            }

            if (validacao) {
                form.submit();
            } else {
                captcha = makeid(5);
                $('.captcha').text(captcha);
                $result_field.val('');
                form.find('.alert').show(100).addClass('alert-danger').text('Confira os campos e tente novamente!');
            }
        });

        $(document).on('keyup', '.senha_confirm', function () {
            let senha = $(this).closest('form').find('input[name="senha"]');
            let confirma = $(this).closest('form').find('.confirma_senha');
            if (senha.val() != '' && confirma.val() != '' && senha.val() != confirma.val()) {
                confirma.addClass('input-error');
                confirma.addClass('input-error').closest('div').addClass('confirma_error');
            } else {
                confirma.removeClass('input-error');
                confirma.removeClass('input-error').closest('div').removeClass('confirma_error');
            }
        });

        $(document).on('click', '.formAPI', function () {
            let $thisform = $(this).parents('form');
            let $result = $thisform.find('.result');
            let $formName = $thisform.find("input[name='redirect']").val();
            let valid = true;
            $result.hide(100).text('');
            $thisform.find('.result.erro').removeClass('erro');

            $thisform.find('[required]').each(function () {
                if (!$(this).val()) {
                    $(this).addClass('input-error');
                }
            });
            if ($thisform.find('input[name="senha"]').val() != '') {
                let senha = $thisform.find('input[name="senha"]');
                let confirma = $thisform.find('.confirma_senha');
                if (senha.val() != confirma.val()) {
                    confirma.addClass('input-error');
                }
            }

            valid = !$thisform.find('.input-error').length;
            if (valid) {
                $thisform.addClass('loading');
                $.ajax({
                    url: $urlApi + 'forms.php',
                    method: $thisform.attr('method'),
                    data: $thisform.serializeObject(),
                    xhrFields: {
                        withCredentials: true
                    },
                    dataType: 'json',
                    success: function (data) {
                        if (data.success) {
                            if (data.aviso) {
                                window.location = $formName + '?status=aviso&msg=' + data.msg;
                            } else {
                                window.location = $formName + '?status=sucesso&msg=' + data.msg;
                            }
                        }
                        else {
                            $result.show(100).addClass('erro').text(data.msg)
                        }
                    },
                    complete: function () {
                        setTimeout(function () {
                            $thisform.removeClass('loading');
                        }, 2000);
                    }
                });
            } else {
                $result.show(100).addClass('erro').text('Confira os campos e tente novamente')
            }
        });
        $(document).on('click', '#botaoLogout', function () {
            $.ajax({
                url: $urlApi + 'forms.php',
                method: 'POST',
                data: { form: 'deslogar_cliente' },
                cache: false,
                success: () => {
                    window.location = '/';
                }
            });
        });
        if ($('.mensagem_resposta').length > 0) {
            $('.mensagem_resposta').delay(4500).fadeOut(500);
        }

        $(document).on('click', '.desabilitar', function () {
            const $id = $(this).data("id");
            const $tabela = 'cliente_site';
            let confirmacao = confirm("Tem certeza que deseja desabilitar sua conta?");
            if (confirmacao) {
                $.ajax({
                    url: $urlApi + 'forms.php',
                    method: 'DELETE',
                    data: { id: $id, form: $tabela },
                    dataType: 'json',
                    success: function (data) {
                        if (data.success) {
                            window.location = '/?status=sucesso&msg=' + data.msg;
                        } else {
                            erroToast(data.msg);
                            setTimeout(function () {
                                window.location = '';
                            }, 2000);
                        }
                    }
                });
            }
        });
        $(document).on('click','.fecha-whats', function(){
            $(this).closest('.conteudo').hide(200);
        })

    });
})(jQuery);