<?php
include_once 'api/vendor/autoload.php';

$db = new MysqliDb([
    'host' => 'localhost',
    'username' => 'gruporrc_landingpagefbwei',
    'password' => 'gIqZ[+ixD}Y[',
    'db' => 'gruporrc_landingpagefbwei',
    'port' => 3306,
    'charset' => 'utf8'
]);

$lazer = $db->orderBy('ordem', 'ASC')->where('tipo', 'lazer')->get('areas');
$estrutura = $db->orderBy('ordem', 'ASC')->where('tipo', 'estrutura')->get('areas');
$turismo = $db->orderBy('ordem', 'ASC')->where('tipo', 'turismo')->get('areas');

$slide = $db->orderBy('ordem', 'ASC')->get('slide');

$whatsapp = 'https://api.whatsapp.com/send?phone=5528999319738&text=Olá, Gostaria de ter mais informações sobre o Infinity Coast Residence! Aguardo seu contato, obrigado';
?>
<!DOCTYPE html>

<head>
    <?php include_once 'partials/head.php' ?>
    <!-- Google Tag Manager -->
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-WQCQFZS');
    </script>
    <!-- End Google Tag Manager -->
</head>

<body class="home page-template page-template-frontpage page-template-frontpage-php page page-id-76 onepage wpb-js-composer js-comp-ver-5.7 vc_responsive elementor-default" data-spy="scroll" data-target=".navigation">

    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WQCQFZS" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->
    <?php if (!empty($_GET['status']) && !empty($_GET['msg'])) { ?>
        <div class="mensagem_resposta <?= $_GET['status'] ?>"><?= $_GET['msg'] ?></div>
    <?php } ?>
    <!-- <div id="load"></div> -->
    <!-- START PAGE WRAP -->
    <div class="page-wrap ">
        <!-- HEADER SECTION -->
        <div id="home" class="page751 section  home ">
            <!-- SECTION -->
            <div class="container">
                <div class="sixteen columns">
                    <div data-vc-full-width="true" data-vc-full-width-init="false" class="vc_row wpb_row vc_row-fluid tarjahome vc_custom_1583015235223 vc_row-has-fill">
                        <div class="wpb_column vc_column_container vc_col-sm-12">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <p><img class="aligncenter size-full wp-image-7" src="/images/logo.png" alt="Infinity Coast" height="78" /></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row-full-width vc_clearfix"></div>
                </div>
            </div>
        </div>
        <!--END SECTION -->
        <!-- START NAVIGATION -->
        <nav class=" navigation light sticky-nav">
            <!-- START CONTAINER -->
            <div class="container clearfix">
                <!-- BEGIN NAVIGATION SECTION -->
                <div class="twelve columns">
                    <!-- START NAVIGATION MENU ITEMS -->
                    <ul id="nav" class="main-menu large nav sf-menu sf-js-enabled">
                        </li>
                        <li id="menu-item-754" class="menu-item menu-item-type-post_type menu-item-object-page"><a href="#home"><span>HOME</span></a></li>
                        <li id="menu-item-756" class="menu-item menu-item-type-post_type menu-item-object-page"><a href="#localizacao"><span>LOCALIZAÇÃO</span></a></li>
                        <li id="menu-item-755" class="menu-item menu-item-type-post_type menu-item-object-page"><a href="#lazer"><span>LAZER</span></a></li>
                        <li id="menu-item-901" class="menu-item menu-item-type-post_type menu-item-object-page"><a href="#apartamentos"><span>APARTAMENTOS</span></a></li>
                        <li id="menu-item-760" class="menu-item menu-item-type-post_type menu-item-object-page"><a href="#ficha-tecnica"><span>FICHA TÉCNICA</span></a></li>
                        <li id="menu-item-752" class="menu-item menu-item-type-post_type menu-item-object-page"><a href="#construcao"><span>CONSTRUÇÃO</span></a></li>
                        <li id="menu-item-840" class="menu-item menu-item-type-post_type menu-item-object-page"><a href="#contato"><span>CONTATO</span></a></li>
                        <li id="menu-item-849" class="menu-item menu-item-type-post_type menu-item-object-page"><a href="tel:28999319738"><button class="btn-menu">Ligue agora: (28) 99931-9738</button></a></li>
                    </ul>
                    <!-- END NAVIGATION MENU ITEMS -->
                </div><!-- END TWELVE COLUMNS -->
            </div><!-- END CONTAINER -->
        </nav>
        <div class="top_panoramica">
            <div id="rev_slider_1_1_wrapper" class="rev_slider_wrapper fullwidthbanner-container" data-source="gallery" style="margin:0px auto;background:transparent;padding:0px;margin-top:0px;margin-bottom:0px;">
                <!-- START REVOLUTION SLIDER 5.4.6.4 fullwidth mode -->
                <div id="rev_slider_1_1" class="rev_slider fullwidthabanner" style="display:none;" data-version="5.4.6.4">
                    <ul>
                        <?php foreach ($slide as $item) { ?>
                            <!-- SLIDE  -->
                            <li data-index="rs-<?= $item['id'] ?>" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off" data-easein="default" data-easeout="default" data-masterspeed="300" data-thumb="<?= $item['imagem'] ?>" data-rotate="0" data-saveperformance="off" data-title="<?= $item['titulo'] ?>" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
                                <!-- MAIN IMAGE -->
                                <img src="<?= $item['imagem'] ?>" alt="<?= $item['titulo'] ?>" title="homeslider_3.jpg" width="1400" height="700" data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" class="rev-slidebg" data-no-retina>
                                <!-- LAYERS -->
                                <!-- LAYER NR. 1 -->
                                <div class="tp-caption   tp-resizeme" id="slide-<?= $item['id'] ?>-layer-1" data-x="['left','left','left','left']" data-hoffset="['355','355','355','74']" data-y="['center','center','center','center']" data-width="none" data-height="none" data-whitespace="nowrap" data-type="image" data-responsive_offset="on" data-frames='[{"delay":0,"speed":300,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;","ease":"Power3.easeInOut"}]' data-textAlign="['inherit','inherit','inherit','inherit']" data-paddingtop="[0,0,0,0]" data-paddingright="[0,0,0,0]" data-paddingbottom="[0,0,0,0]" data-paddingleft="[0,0,0,0]" style="z-index: 5;">
                                    <img src="/images/bloco-slide.png" alt="" data-ww="['680px','680px','680px','505px']" data-hh="['175px','175px','175px','130px']" width="680" height="175" data-no-retina>
                                </div>

                                <!-- LAYER NR. 2 -->
                                <div class="tp-caption tp-resizeme bloco-slide" id="slide-<?= $item['id'] ?>-layer-1" data-x="['center','center','center','center']" data-voffset="['150','150','150','150']" data-y="['center','center','center','center']" data-width="none" data-height="none" data-whitespace="nowrap" data-type="image" data-responsive_offset="on" data-frames='[{"delay":0,"speed":300,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;","ease":"Power3.easeInOut"}]' data-textAlign="['inherit','inherit','inherit','inherit']" data-paddingtop="[0,0,0,0]" data-paddingright="[0,0,0,0]" data-paddingbottom="[0,0,0,0]" data-paddingleft="[0,0,0,0]" style="z-index: 5;">
                                    <a href="#contato">
                                        <button class="btn-slide">Cadastre-se para mais informações</button>
                                    </a>
                                </div>

                            </li>
                        <?php } ?>
                    </ul>
                    <script>
                        var htmlDiv = document.getElementById("rs-plugin-settings-inline-css");
                        var htmlDivCss = "";
                        if (htmlDiv) {
                            htmlDiv.innerHTML = htmlDiv.innerHTML + htmlDivCss;
                        } else {
                            var htmlDiv = document.createElement("div");
                            htmlDiv.innerHTML = "<style>" + htmlDivCss + "</style>";
                            document.getElementsByTagName("head")[0].appendChild(htmlDiv.childNodes[0]);
                        }
                    </script>
                    <div class="tp-bannertimer tp-bottom" style="visibility: hidden !important;"></div>
                </div>
                <script src="/assets/js/slide.js"></script>
            </div><!-- END REVOLUTION SLIDER -->
        </div>
        <!-- END NAVIGATION -->
        <div id="localizacao" class="page69 section  localizacao ">
            <!-- SECTION -->
            <div class="container">
                <div class="sixteen columns">
                    <div data-vc-full-width="true" data-vc-full-width-init="false" class="vc_row wpb_row vc_row-fluid back_cinza">
                        <div class="wpb_column vc_column_container vc_col-sm-12 vc_hidden-xs">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="vc_empty_space" style="height: 10px"><span class="vc_empty_space_inner"></span></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row-full-width vc_clearfix"></div>
                    <div data-vc-full-width="true" data-vc-full-width-init="false" class="vc_row wpb_row vc_row-fluid back_cinza vc_custom_1582420180343 vc_row-has-fill">
                        <div class="wpb_column vc_column_container vc_col-sm-2">
                            <div class="vc_column-inner vc_custom_1582238113050">
                                <div class="wpb_wrapper"></div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-8">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <h2 class="subtitulo text-center">Muito além do que se espera. . .</h2>
                                            <div style="margin-bottom: -8px;" class="text-center"><b>Infnity Coast Residence</b> é a resposta para um mercado que não se contenta com o fato de morar, mas busca viver o que há de melhor. Uma região frequentada e escolhida por pessoas que valorizam os bons momentos e não abrem mão de um lugar turístico.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-2">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper"></div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row-full-width vc_clearfix"></div>
                    <div data-vc-full-width="true" data-vc-full-width-init="false" class="vc_row wpb_row vc_row-fluid back_cinza vc_custom_1582248549610 vc_row-has-fill">
                        <div class="wpb_column vc_column_container vc_col-sm-12 vc_hidden-xs">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_single_image wpb_content_element vc_align_center">
                                        <figure class="wpb_wrapper vc_figure">
                                            <a data-rel="prettyPhoto[rel-69-422069893]" href="/images/localizacao.jpg" target="_self" class="vc_single_image-wrapper   vc_box_border_grey prettyphoto"><img width="1200" height="514" src="/images/localizacao.jpg" class="vc_single_image-img attachment-full" alt="Localização" /></a>
                                        </figure>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row-full-width vc_clearfix"></div>
                    <div data-vc-full-width="true" data-vc-full-width-init="false" class="vc_row wpb_row vc_row-fluid back_cinza vc_custom_1582248549610 vc_row-has-fill">
                        <div class="wpb_column vc_column_container vc_col-sm-12 vc_hidden-lg vc_hidden-md vc_hidden-sm">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_single_image wpb_content_element vc_align_center">
                                        <figure class="wpb_wrapper vc_figure">
                                            <a data-rel="prettyPhoto[rel-69-2034531020]" href="/images/localizacao.jpg" target="_self" class="vc_single_image-wrapper   vc_box_border_grey prettyphoto"><img width="700" height="408" src="/images/localizacao.jpg" class="vc_single_image-img attachment-full" alt="" srcset="https://novo.gruporrcosta.com//images/localizacao.jpg 700w, https://novo.gruporrcosta.com/conteudos/uploads/2020/02/mapa4-300x175.jpg 300w" sizes="(max-width: 700px) 100vw, 700px" /></a>
                                        </figure>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row-full-width vc_clearfix"></div>
                    <div data-vc-full-width="true" data-vc-full-width-init="false" class="vc_row wpb_row vc_row-fluid back_cinza vc_custom_1582248549610 vc_row-has-fill">
                        <div class="wpb_column vc_column_container vc_col-sm-2">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper"></div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-8">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <div class="texto_meio text-center">Localizado no Balneário de Iriri, entre a Praia da Costa Azul e Praia da Areia Preta, em Anchieta, o novo empreendimento da RR Costa Construções, também intitulado Residence Infnity Coast, será entregue em outubro de 2022.</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-2">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper"></div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row-full-width vc_clearfix"></div>
                </div>
            </div>
        </div>
        <div id="lazer" class="page69 section  localizacao ">
            <!-- SECTION -->
            <div class="container">
                <div class="sixteen columns">
                    <div class="vc_row-full-width vc_clearfix"></div>
                    <div data-vc-full-width="true" data-vc-full-width-init="false" class="vc_row wpb_row vc_row-fluid largura_slider">
                        <div class="wpb_column vc_column_container vc_col-sm-12 vc_hidden-xs">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div id="rev_slider_2_2_wrapper" class="rev_slider_wrapper fullwidthbanner-container" data-source="gallery" style="margin:0px auto;background:transparent;padding:0px;margin-top:0px;margin-bottom:0px;">
                                        <!-- START REVOLUTION SLIDER 5.4.6.4 auto mode -->
                                        <div id="rev_slider_2_2" class="rev_slider fullwidthabanner" style="display:none;" data-version="5.4.6.4">
                                            <ul>

                                                <?php foreach ($turismo as $item) { ?>

                                                    <!-- SLIDE  -->
                                                    <li data-index="rs-<?= $item['id'] ?>" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off" data-easein="default" data-easeout="default" data-masterspeed="300" data-thumb="<?= $item['imagem'] ?>" data-rotate="0" data-saveperformance="off" data-title="<?= $item['titulo'] ?>" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
                                                        <!-- MAIN IMAGE -->
                                                        <img src="<?= $item['imagem'] ?>" alt="<?= $item['titulo'] ?>" title="<?= $item['titulo'] ?>" width="900" height="591" data-lazyload="<?= $item['imagem'] ?>" data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" data-bgparallax="off" class="rev-slidebg" data-no-retina>
                                                        <!-- LAYERS -->
                                                        <div class="tp-caption   tp-resizeme" id="slide-<?= $item['id'] ?>-layer-1" data-x="right" data-y="25" data-width="['auto']" data-height="['auto']" data-type="text" data-responsive_offset="on" data-frames='[{"delay":0,"speed":300,"frame":"0","from":"opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;","ease":"Power3.easeInOut"}]' data-textAlign="['inherit','inherit','inherit','inherit']" data-paddingtop="[0,0,0,0]" data-paddingright="[0,0,0,0]" data-paddingbottom="[0,0,0,0]" data-paddingleft="[0,0,0,0]" style="z-index: 5; white-space: nowrap; font-size: 20px; line-height: 22px; font-weight: 400; color: #ffffff; letter-spacing: 0px;">
                                                            <div style="background: rgba(22, 53, 86, 0.7); padding: 18px; font-size:17px"><?= $item['titulo'] ?></div>
                                                        </div>
                                                    </li>
                                                <?php } ?>
                                            </ul>
                                            <script>
                                                var htmlDiv = document.getElementById("rs-plugin-settings-inline-css");
                                                var htmlDivCss = "";
                                                if (htmlDiv) {
                                                    htmlDiv.innerHTML = htmlDiv.innerHTML + htmlDivCss;
                                                } else {
                                                    var htmlDiv = document.createElement("div");
                                                    htmlDiv.innerHTML = "<style>" + htmlDivCss + "</style>";
                                                    document.getElementsByTagName("head")[0].appendChild(htmlDiv.childNodes[0]);
                                                }
                                            </script>
                                            <div class="tp-bannertimer tp-bottom" style="visibility: hidden !important;"></div>
                                        </div>
                                        <script src="assets/js/slide-2.js"></script>
                                    </div><!-- END REVOLUTION SLIDER -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row-full-width vc_clearfix"></div>
                </div>
            </div>
        </div>
        <!--END SECTION -->
        <div class="page71 section  lazer ">
            <!-- SECTION -->
            <div class="container">
                <div class="sixteen columns">
                    <div data-vc-full-width="true" data-vc-full-width-init="false" class="vc_row wpb_row vc_row-fluid">
                        <div class="wpb_column vc_column_container vc_col-sm-2">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper"></div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-8">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <h2 class="subtitulo text-center">Entretenimento, descontração e as grandes celebrações feitas em alto estilo.</h2>
                                            <p class="text-center">Itens especialmente selecionados para valorizar ainda mais seus momentos de descontração, lazer, convívio e comemorações.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-2">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper"></div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row-full-width vc_clearfix"></div>
                    <div data-vc-full-width="true" data-vc-full-width-init="false" class="vc_row wpb_row vc_row-fluid pg_branca vc_custom_1582247635263 vc_row-has-fill">
                        <div class="wpb_column vc_column_container vc_col-sm-3">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <h3 style="white-space: nowrap; overflow: visible; position: relative; z-index: 99;">Planta humanizada - Área de laser</h3>
                                            <div class="numer_plantas">1. Piscina<br /> 2. Salão de festa<br /> 3. Brinquedoteca <br /> 4. Academia<br /> 5. Área Gourmet<br /> 6. Sauna</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-9">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_single_image wpb_content_element vc_align_center">
                                        <figure class="wpb_wrapper vc_figure">
                                            <a data-rel="prettyPhoto[rel-71-1677619577]" href="/images/planta-humanizada-lazer.jpg" target="_self" class="vc_single_image-wrapper vc_box_border_grey prettyphoto"><img width="1024" height="584" src="/images/planta-humanizada-lazer.jpg" class="vc_single_image-img attachment-full" alt="Planta Humanizada" /></a>
                                        </figure>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row-full-width vc_clearfix"></div>
                </div>
            </div>
        </div>
        <!--END SECTION -->
        <div id="apartamentos" class="page877 section  apartamentos ">
            <!-- SECTION -->
            <div class="container">
                <div class="sixteen columns">
                    <div data-elementor-type="wp-page" data-elementor-id="877" class="elementor elementor-877" data-elementor-settings="[]">
                        <div class="elementor-inner">
                            <div class="elementor-section-wrap">
                                <section class="elementor-element elementor-element-7f32e45f elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-id="7f32e45f" data-element_type="section">
                                    <div class="elementor-container elementor-column-gap-default">
                                        <div class="elementor-row">
                                            <div class="elementor-element elementor-element-36eeebc elementor-column elementor-col-100 elementor-top-column" data-id="36eeebc" data-element_type="column">
                                                <div class="elementor-column-wrap  elementor-element-populated">
                                                    <div class="elementor-widget-wrap">
                                                        <div class="elementor-element elementor-element-049b501 elementor-widget elementor-widget-text-editor" data-id="049b501" data-element_type="widget" data-widget_type="text-editor.default">
                                                            <div class="elementor-widget-container">
                                                                <div class="elementor-text-editor elementor-clearfix">
                                                                    <p class="titulo_ap">Um apartamento sob medida para o seu estilo de vida.</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </section>
                                <section class="elementor-element elementor-element-eb4f292 elementor-section-stretched elementor-section-full_width elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-id="eb4f292" data-element_type="section" data-settings='{"stretch_section":"section-stretched"}'>
                                    <div class="elementor-container elementor-column-gap-extended">
                                        <div class="elementor-row">
                                            <div class="elementor-element elementor-element-e64fdb7 elementor-column elementor-col-100 elementor-top-column" data-id="e64fdb7" data-element_type="column">
                                                <div class="elementor-column-wrap  elementor-element-populated">
                                                    <div class="elementor-widget-wrap">
                                                        <div class="elementor-element elementor-element-e81334c elementor-arrows-position-outside elementor-hidden-tablet elementor-hidden-phone elementor-pagination-position-outside elementor-widget elementor-widget-image-carousel" data-id="e81334c" data-element_type="widget" data-settings='{"slides_to_show":"2","autoplay":"no","navigation":"both","infinite":"yes","speed":500,"direction":"ltr"}' data-widget_type="image-carousel.default">
                                                            <div class="elementor-widget-container">
                                                                <div class="elementor-image-carousel-wrapper swiper-container" dir="ltr">
                                                                    <div class="elementor-image-carousel swiper-wrapper">
                                                                        <?php foreach ($estrutura as $item) { ?>
                                                                            <div class="swiper-slide">
                                                                                <a data-elementor-open-lightbox="yes" data-elementor-lightbox-slideshow="e81334c" href="<?= $item['imagem'] ?>">
                                                                                    <figure class="swiper-slide-inner"><img class="swiper-slide-image" src="<?= $item['imagem'] ?>" alt="<?= $item['titulo'] ?>" /></figure>
                                                                                </a>
                                                                            </div>
                                                                        <?php } ?>
                                                                    </div>
                                                                    <div class="swiper-pagination"></div>
                                                                    <div class="elementor-swiper-button elementor-swiper-button-prev">
                                                                        <i class="eicon-chevron-left" aria-hidden="true"></i>
                                                                        <span class="elementor-screen-only">Anterior</span>
                                                                    </div>
                                                                    <div class="elementor-swiper-button elementor-swiper-button-next">
                                                                        <i class="eicon-chevron-right" aria-hidden="true"></i>
                                                                        <span class="elementor-screen-only">Próximo</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </section>
                                <section class="elementor-element elementor-element-6d1f614 elementor-section-stretched elementor-section-full_width elementor-hidden-desktop elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-id="6d1f614" data-element_type="section" data-settings="{'stretch_section':'section-stretched'}">
                                    <div class="elementor-container elementor-column-gap-extended">
                                        <div class="elementor-row">
                                            <div class="elementor-element elementor-element-29b2fde elementor-column elementor-col-100 elementor-top-column" data-id="29b2fde" data-element_type="column">
                                                <div class="elementor-column-wrap  elementor-element-populated">
                                                    <div class="elementor-widget-wrap">
                                                        <div class="elementor-element elementor-element-fe1b477 elementor-arrows-position-inside elementor-pagination-position-outside elementor-widget elementor-widget-image-carousel" data-id="fe1b477" data-element_type="widget" data-settings='{"slides_to_show":"1","autoplay":"no","navigation":"both","infinite":"yes","speed":500,"direction":"ltr"}' data-widget_type="image-carousel.default">
                                                            <div class="elementor-widget-container">
                                                                <div class="elementor-image-carousel-wrapper swiper-container" dir="ltr">
                                                                    <div class="elementor-image-carousel swiper-wrapper">
                                                                        <?php foreach ($estrutura as $item) { ?>
                                                                            <div class="swiper-slide">
                                                                                <a data-elementor-open-lightbox="yes" data-elementor-lightbox-slideshow="fe1b477" href="<?= $item['imagem'] ?>">
                                                                                    <figure class="swiper-slide-inner"><img class="swiper-slide-image" src="<?= $item['imagem'] ?>" alt="<?= $item['titulo'] ?>" /></figure>
                                                                                </a>
                                                                            </div>
                                                                        <?php } ?>
                                                                    </div>
                                                                    <div class="swiper-pagination"></div>
                                                                    <div class="elementor-swiper-button elementor-swiper-button-prev">
                                                                        <i class="eicon-chevron-left" aria-hidden="true"></i>
                                                                        <span class="elementor-screen-only">Anterior</span>
                                                                    </div>
                                                                    <div class="elementor-swiper-button elementor-swiper-button-next">
                                                                        <i class="eicon-chevron-right" aria-hidden="true"></i>
                                                                        <span class="elementor-screen-only">Próximo</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </section>
                                <div class="text-center">
                                    <a href="#contato">
                                        <button class="btn-slide">Cadastre-se para mais informações</button>
                                    </a>
                                </div>
                                <section class="elementor-element elementor-element-25b5686 elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-id="25b5686" data-element_type="section">
                                    <div class="elementor-container elementor-column-gap-default">
                                        <div class="elementor-row">
                                            <div class="elementor-element elementor-element-c811fc8 elementor-column elementor-col-100 elementor-top-column" data-id="c811fc8" data-element_type="column">
                                                <div class="elementor-column-wrap  elementor-element-populated">
                                                    <div class="elementor-widget-wrap">
                                                        <div class="elementor-element elementor-element-e9b0cc0 elementor-arrows-position-inside elementor-widget elementor-widget-image-carousel" data-id="e9b0cc0" data-element_type="widget" data-settings='{"slides_to_show":"1","navigation":"arrows","autoplay_speed":4000,"autoplay":"yes","pause_on_hover":"yes","pause_on_interaction":"yes","infinite":"yes","effect":"slide","speed":500,"direction":"ltr"}' data-widget_type="image-carousel.default">
                                                            <div class="elementor-widget-container">
                                                                <div class="elementor-image-carousel-wrapper swiper-container" dir="ltr">
                                                                    <div class="elementor-image-carousel swiper-wrapper">
                                                                        <?php foreach ($lazer as $item) { ?>
                                                                            <div class="swiper-slide">
                                                                                <a data-elementor-open-lightbox="yes" data-elementor-lightbox-slideshow="e9b0cc0" data-elementor-lightbox-title="<?= $item['titulo'] ?>" href="<?= $item['imagem'] ?>">
                                                                                    <figure class="swiper-slide-inner"><img class="swiper-slide-image" src="<?= $item['imagem'] ?>" alt="<?= $item['titulo'] ?>" /></figure>
                                                                                </a>
                                                                            </div>
                                                                        <?php } ?>
                                                                    </div>
                                                                    <div class="elementor-swiper-button elementor-swiper-button-prev">
                                                                        <i class="eicon-chevron-left" aria-hidden="true"></i>
                                                                        <span class="elementor-screen-only">Anterior</span>
                                                                    </div>
                                                                    <div class="elementor-swiper-button elementor-swiper-button-next">
                                                                        <i class="eicon-chevron-right" aria-hidden="true"></i>
                                                                        <span class="elementor-screen-only">Próximo</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--END SECTION -->
        <div id="ficha-tecnica" class="page154 section  ficha-tecnica ">
            <!-- SECTION -->
            <div class="container">

                <div class="sixteen columns">
                    <div data-vc-full-width="true" data-vc-full-width-init="false" class="vc_row wpb_row vc_row-fluid fichatecnica">
                        <div class="wpb_column vc_column_container vc_col-sm-3">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <p><img class="alignnone wp-image-168 size-full" style="padding-bottom: 25px;" src="/images/logo-branca.png" alt="Infinity Coast" height="208" /></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-3">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <h3 style="font-size: 30px; color: #fff;  margin-bottom: 25px;">Ficha Técnica</h3>
                                            <p><span style="color: #ffffff;"><strong>Realização:</strong><br />
                                                    RR Costa Construções</span></p>

                                            <p><span style="color: #ffffff;"><strong>Nº de Torres:</strong> 1</span></p>

                                            <p><span style="color: #ffffff;"><strong>Área do Terreno::</strong><br /> 937,15 m²</span></p>

                                            <p><span style="color: #ffffff;"><strong>INFINITY COAST RESIDENCE:</strong><br />Av. Beira Mar, Lote 24/23,33/34 e 32,
                                                    Bairro de Fátima, BALNEÁRIO DE IRIRI- Anchieta-ES</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-3">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <div class="ficha_texto">
                                                <p><span style="color: #ffffff;"><strong>Nº de Unidades por Andar:</strong><br /> 7 unidades por andar</span></p>

                                                <p><span style="color: #ffffff;"><strong>Nº de Dormitórios:</strong> <br />2 e 3 quartos com 1 suíte ou 2 suítes</span></p>

                                                <p><span style="color: #ffffff;"><strong>Nº de Pavimentos:</strong><br />
                                                        Subsolo<br />
                                                        Garagem 1/Lazer<br />
                                                        Garagem 2<br />
                                                        1º Pavimento Térreo/Portaria<br />
                                                        2º Pavimento Tipo<br />
                                                        3° Pavimento Tipo<br />
                                                        4° Pavimento / Coberturas</span></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-3">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <div class="ficha_texto">
                                                <p><span style="color: #ffffff;"><strong>Nº de Vagas:</strong><br />Apartamentos com até 2 vagas de garagem</span></p>

                                                <p><span style="color: #ffffff;"><strong>Nº de Elevadores:</strong><br />2 Elevadores</span></p>
                                                <p><span style="color: #ffffff;"><strong>Nº Total de vagas:</strong><br />23 unidades residenciais</span></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row-full-width vc_clearfix"></div>
                </div>
            </div>
        </div>
        <!--END SECTION -->
        <div id="construcao" class="page173 section  construcao ">
            <!-- SECTION -->
            <div class="container">
                <div class="sixteen columns">
                    <div data-vc-full-width="true" data-vc-full-width-init="false" class="vc_row wpb_row vc_row-fluid realizacao_01">
                        <div class="wpb_column vc_column_container vc_col-sm-12">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                        </div>
                                    </div>
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <h3 style="font-size: 30px; color: #105a96;  margin-bottom: 25px; text-align: center;">Construção:</h3>
                                            <p><img class="wp-image-177 size-full aligncenter" src="/images/logo-rr-costa.png" alt="Grupo RRCosta Construções" width="252" height="74" /></p>
                                        </div>
                                    </div>
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper text-center">
                                            <p style="text-align: center; margin-top: 50px;">Com 15 anos de atuação na área da construção civil do Espírito Santo, a RR Costa Construções é, hoje, uma referência em obras de engenharia, gerando centenas de empregos diretos e indiretos, e seus funcionários sentem imenso orgulho de fazer parte da evolução deste sonho.</p>
                                            <p>É uma empresa completa que atende todo o Espírito Santo prestando serviços nas mais diversas áreas, como obras de arquitetura, incorporações, edificações, obras de urbanização, saneamento básico, drenagem pluvial e revitalização urbana.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row-full-width vc_clearfix"></div>
                    <div class="vc_row wpb_row vc_row-fluid">
                        <div class="wpb_column vc_column_container vc_col-sm-12 vc_hidden-lg vc_hidden-md vc_hidden-sm">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <h3 style="font-size: 30px; color: #105a96;  margin: 25px 0; text-align: center; line-height: 34px; padding: 0px 20px;"><strong>Quer saber mais sobre o Infinity Coast?</strong><br />Entre em contato pelo telefone ou preencha com seus dados abaixo e conheça as condições de pagamento</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row wpb_row vc_row-fluid">
                        <div class="wpb_column vc_column_container vc_col-sm-12 vc_hidden-lg vc_hidden-md vc_hidden-sm">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <p><iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1798.9224382517!2d-40.69494834194486!3d-20.834111489694152!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMjDCsDUwJzAyLjgiUyA0MMKwNDEnMzcuOSJX!5e1!3m2!1sen!2sbr!4v1602102977422!5m2!1sen!2sbr" width="100%" height="450" frameborder="0" style="border:0;" allowfullscreen="" aria-hidden="false" tabindex="0"></iframe></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--END SECTION -->
        <div id="contato" class="page184 section  contato ">
            <!-- SECTION -->
            <div class="container">
                <div class="sixteen columns">
                    <div class="vc_row wpb_row vc_row-fluid contato_pg">
                        <div class="wpb_column vc_column_container vc_col-sm-12 vc_hidden-xs">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <h3 style="font-size: 30px; color: #105a96;  margin: 25px 0; text-align: center; line-height: 34px; padding: 0px 20px;"><strong>Quer saber mais sobre o Infinity Coast?</strong><br />Entre em contato pelo telefone ou preencha com seus dados abaixo e conheça as condições de pagamento</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row wpb_row vc_row-fluid">
                        <div class="wpb_column vc_column_container vc_col-sm-6 vc_hidden-xs">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <p><iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1798.9224382517!2d-40.69494834194486!3d-20.834111489694152!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMjDCsDUwJzAyLjgiUyA0MMKwNDEnMzcuOSJX!5e1!3m2!1sen!2sbr!4v1602102977422!5m2!1sen!2sbr" width="100%" height="450" frameborder="0" style="border:0;" allowfullscreen="" aria-hidden="false" tabindex="0"></iframe></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="wpb_column vc_column_container vc_col-sm-6">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <div style="font-size: 28px; text-align: center; margin-bottom: -20px; color: #105a96;"><a href="tel:28999319738"><h3><button class="btn-menu text-uppercase"> Fele Conosco</button></h3></a></div>
                                        </div>
                                    </div>
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <div role="form" class="wpcf7" id="wpcf7-f794-o1" lang="pt-BR" dir="ltr">
                                                <div class="screen-reader-response"></div>
                                                <form method="POST" action="funcoes/contato.php" class="wpcf7-form">
                                                    <p><label><br />
                                                            <span class="wpcf7-form-control-wrap your-name"><input type="text" name="nome" value="" size="40" class="wpcf7-form-control wpcf7-text wpcf7-validates-as-required form01" aria-required="true" aria-invalid="false" placeholder="NOME COMPLETO*" /></span> </label></p>
                                                    <p><label><br />
                                                            <span class="wpcf7-form-control-wrap your-email"><input type="email" name="email" value="" size="40" class="wpcf7-form-control wpcf7-text wpcf7-email wpcf7-validates-as-required wpcf7-validates-as-email form01" aria-required="true" aria-invalid="false" placeholder="E-MAIL*" /></span> </label></p>
                                                    <p><label><br />
                                                            <span class="wpcf7-form-control-wrap tel-342"><input type="tel" name="telefone" value="" size="40" class="wpcf7-form-control wpcf7-text wpcf7-tel wpcf7-validates-as-required wpcf7-validates-as-tel form02" aria-required="true" aria-invalid="false" placeholder="TELEFONE*" /></span></label></p>
                                                    <p><label><br />
                                                            <span class="wpcf7-form-control-wrap your-message"><textarea name="mensagem" cols="40" rows="10" class="wpcf7-form-control wpcf7-textarea wpcf7-validates-as-required form01" aria-required="true" aria-invalid="false" placeholder="MENSAGEM*"></textarea></span> </label></p>
                                                    <p>
                                                        <button type="button" class="btn captcha"></button> <input class="captcha_result" placeholder="Insira caracteres ao lado" required />
                                                    </p>
                                                    <p>
                                                        <div class="alert" style="display: none"></div>
                                                    </p>
                                                    <p><input type="button" value="Enviar" class="wpcf7-form-control wpcf7-submit formSubmit" /></p>
                                                    <div class="wpcf7-response-output wpcf7-display-none"></div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="vc_row wpb_row vc_row-fluid">
                        <div class="wpb_column vc_column_container vc_col-sm-12 vc_hidden-lg vc_hidden-md vc_hidden-sm vc_hidden-xs">
                            <div class="vc_column-inner">
                                <div class="wpb_wrapper">
                                    <div class="wpb_text_column wpb_content_element ">
                                        <div class="wpb_wrapper">
                                            <p>Todas as fotos, mapas, perspectivas e plantas contidos neste material publicitário são meramente ilustrativos, seus elementos de composição podem sofrer alterações de cor, forma, textura e tamanho. As unidades privativas e áreas comuns serão entregues obedecendo ao projeto executivo e conforme as especificações constantes do Memorial de Incorporação, que prevalecerá em caso de conflito com qualquer outro material e/ou informação relativos ao empreendimento. A decoração, iluminação, equipamentos e mobiliário das unidades privativas são apenas sugestões, não fazendo parte das obrigações de entrega. A montagem e decoração das eareas comuns e de lazer serão entregues conforme Memorial Descritivo anexo ao Contrato de Compra e Venda. Projeto aprovado na PMV- sob o nº 184579/2017 em 24/06/2019. Registro de incorporação protocolado sob o nº 125.124 no Cartório de Registro de Imóveis da 3ª zona de Vitória/ ES . Impresso em 11/2019</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--END SECTION -->

        <!-- START COPYRIGHT SECTION -->
        <div class="copyright aligncenter">
            <div class="container clearfix">
                <div class="rodape_esq">© Copyright <?= date('Y') ?> - Todos os direitos reservados - Grupo RRCosta Construções</div>
            </div> <!-- END SIXTEEN COLUMNS -->
        </div><!-- END CONTAINER -->
    </div>
    <!-- END COPYRIGHT SECTION -->
    <link href="/css/font-awesome.min.css" rel="stylesheet">
    <ul class='social'>
        <li>
            <a class="fa fa-phone" href="tel:2835341947">
                <span>Telefone<br>
                    28 3534-1947</span>
            </a>
        </li>
        <li>
            <a class="fa fa-whatsapp" href="<?= $whatsapp ?>" target="_blank">
                <span>Whatsapp<br>
                    28 99931-9738</span>
            </a>
        </li>
        <li>
            <a class="fa fa-envelope-o" href="#contato">
                <span>Email</span>
            </a>
        </li>
        <li>
            <a class="fa fa-facebook" href="//fb.com/rrcostaconstrucoes/" target="_blank">
                <span>Facebook</span>
            </a>
        </li>
    </ul>

    <div id="back-to-top"><a href="#">Voltar ao topo</a></div>
    <div class="bloco-whatsapp">
        <a href="<?= $whatsapp ?>" target="_blank">
            <button class="btn-whatsapp"><i class="fa fa-whatsapp"></i></button>
        </a>
        <div class="conteudo">
            <i class="fa fa-times-circle fecha-whats"></i>
            <a href="<?= $whatsapp ?>" target="_blank">
                <p>Rosa Vania</p>
                <div class="flex-section">
                    <div class="imagem"><img src="/images/rosa-vania.png" /></div>
                    <div class="texto">Olá! Quer conversar a respeito do Infinity Coast?</div>
                </div>
            </a>
        </div>
    </div>


    <script type="text/javascript">
        function revslider_showDoubleJqueryError(sliderID) {
            var errorMessage = "Revolution Slider Error: You have some jquery.js library include that comes after the revolution files js include.";
            errorMessage += "<br> This includes make eliminates the revolution slider libraries, and make it not work.";
            errorMessage += "<br><br> To fix it you can:<br>&nbsp;&nbsp;&nbsp; 1. In the Slider Settings -> Troubleshooting set option:  <strong><b>Put JS Includes To Body</b></strong> option to true.";
            errorMessage += "<br>&nbsp;&nbsp;&nbsp; 2. Find the double jquery.js include and remove it.";
            errorMessage = "<span style='font-size:16px;color:#BC0C06;'>" + errorMessage + "</span>";
            jQuery(sliderID).show().html(errorMessage);
        }
    </script>

    <link rel='stylesheet' id='js_composer_front-css' href='conteudos/plugins/js_composer/assets/css/js_composer.mine23c.css?ver=5.7' type='text/css' media='all' />
    <link rel='stylesheet' id='prettyphoto-css' href='conteudos/plugins/js_composer/assets/lib/prettyphoto/css/prettyPhoto.mine23c.css?ver=5.7' type='text/css' media='all' />
    <link rel='stylesheet' id='elementor-frontend-css' href='conteudos/plugins/elementor/assets/css/frontend.min4315.css?ver=2.9.8' type='text/css' media='all' />
    <link rel='stylesheet' id='elementor-post-877-css' href='conteudos/uploads/elementor/css/post-877dfa3.css?ver=1600800420' type='text/css' media='all' />
    <link rel='stylesheet' id='elementor-icons-css' href='conteudos/plugins/elementor/assets/lib/eicons/css/elementor-icons.min4c7e.css?ver=5.6.2' type='text/css' media='all' />
    <link rel='stylesheet' id='elementor-animations-css' href='conteudos/plugins/elementor/assets/lib/animations/animations.min4315.css?ver=2.9.8' type='text/css' media='all' />
    <link rel='stylesheet' id='elementor-pro-css' href='conteudos/plugins/elementor-pro/assets/css/frontend.minf0c3.css?ver=2.9.4' type='text/css' media='all' />
    <link rel='stylesheet' id='elementor-global-css' href='conteudos/uploads/elementor/css/global0b30.css?ver=1599753048' type='text/css' media='all' />
    <script type='text/javascript' src='include/js/comment-reply.min03ec.js?ver=5.3.4'></script>

    <script type='text/javascript' src='conteudos/plugins/contact-form-7/includes/js/scriptsb62d.js?ver=5.1.6'></script>
    <script type='text/javascript' src='include/js/wp-embed.min03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/plugins/js_composer/assets/js/dist/js_composer_front.mine23c.js?ver=5.7'></script>
    <script type='text/javascript' src='conteudos/plugins/js_composer/assets/lib/prettyphoto/js/jquery.prettyPhoto.mine23c.js?ver=5.7'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/jquery.form03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/superfish03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/jquery.queryloader203ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/jquery.waitforimages03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/jquery.appear03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/jquery.slabtext.min03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/jquery.parallax-1.1.303ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/jquery.prettyPhoto03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/jquery.sticky03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/SmoothScroll03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/jquery.flexslider-min03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/bootstrap-modal03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/jquery.easing.min03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/jquery.fittext03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/jquery.fitvids03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/isotope03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/selectnav.min03ec.js?ver=5.3.4'></script>
    <script type='text/javascript'>
        /* <![CDATA[ */
        var rnr_global_vars = {
            "contact_form_required_fields_label_ajax": "This is a required field",
            "contact_form_warning": "Please verify fields and try again.",
            "contact_form_email_warning": "Please enter a valid e-mail address and try again.",
            "contact_form_error": "There was an error sending your email. Please try again later.",
            "contact_form_success_message": "Thanks, we got your mail and will get back to you soon!",
            "contactFormDefaults_name": "Name",
            "contactFormDefaults_email": "E-mail",
            "contactFormDefaults_subject": "Subject",
            "contactFormDefaults_message": "Message",
            "commentFormDefaults_author": "Name",
            "commentFormDefaults_email": "E-mail",
            "commentFormDefaults_url": "https:\/\/",
            "searchFormDefaults_search": "Search"
        };
        /* ]]> */
    </script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/scripts03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/themes/bluebay/js/shortcodes03ec.js?ver=5.3.4'></script>
    <script type='text/javascript' src='conteudos/plugins/elementor/assets/js/frontend-modules.min4315.js?ver=2.9.8'></script>
    <script type='text/javascript' src='conteudos/plugins/elementor-pro/assets/lib/sticky/jquery.sticky.minf0c3.js?ver=2.9.4'></script>
    <script type='text/javascript'>
        var ElementorProFrontendConfig = {
            "ajaxurl": "https:\/\/novo.gruporrcosta.com\/wp-admin\/admin-ajax.php",
            "nonce": "cb54b76d37",
            "i18n": {
                "toc_no_headings_found": "No headings were found on this page."
            },
            "shareButtonsNetworks": {
                "facebook": {
                    "title": "Facebook",
                    "has_counter": true
                },
                "twitter": {
                    "title": "Twitter"
                },
                "google": {
                    "title": "Google+",
                    "has_counter": true
                },
                "linkedin": {
                    "title": "LinkedIn",
                    "has_counter": true
                },
                "pinterest": {
                    "title": "Pinterest",
                    "has_counter": true
                },
                "reddit": {
                    "title": "Reddit",
                    "has_counter": true
                },
                "vk": {
                    "title": "VK",
                    "has_counter": true
                },
                "odnoklassniki": {
                    "title": "OK",
                    "has_counter": true
                },
                "tumblr": {
                    "title": "Tumblr"
                },
                "delicious": {
                    "title": "Delicious"
                },
                "digg": {
                    "title": "Digg"
                },
                "skype": {
                    "title": "Skype"
                },
                "stumbleupon": {
                    "title": "StumbleUpon",
                    "has_counter": true
                },
                "mix": {
                    "title": "Mix"
                },
                "telegram": {
                    "title": "Telegram"
                },
                "pocket": {
                    "title": "Pocket",
                    "has_counter": true
                },
                "xing": {
                    "title": "XING",
                    "has_counter": true
                },
                "whatsapp": {
                    "title": "WhatsApp"
                },
                "email": {
                    "title": "Email"
                },
                "print": {
                    "title": "Print"
                }
            },
            "facebook_sdk": {
                "lang": "pt_BR",
                "app_id": ""
            }
        };
    </script>
    <script type='text/javascript' src='conteudos/plugins/elementor-pro/assets/js/frontend.minf0c3.js?ver=2.9.4'></script>
    <script type='text/javascript' src='include/js/jquery/ui/position.mine899.js?ver=1.11.4'></script>
    <script type='text/javascript' src='conteudos/plugins/elementor/assets/lib/dialog/dialog.minae9e.js?ver=4.7.6'></script>
    <script type='text/javascript' src='conteudos/plugins/elementor/assets/lib/waypoints/waypoints.min05da.js?ver=4.0.2'></script>
    <script type='text/javascript' src='conteudos/plugins/elementor/assets/lib/swiper/swiper.min48f5.js?ver=5.3.6'></script>
    <script type='text/javascript' src='conteudos/plugins/elementor/assets/lib/share-link/share-link.min4315.js?ver=2.9.8'></script>
    <script type='text/javascript'>
        var elementorFrontendConfig = {
            "environmentMode": {
                "edit": false,
                "wpPreview": false
            },
            "i18n": {
                "shareOnFacebook": "Compartilhar no Facebook",
                "shareOnTwitter": "Compartilhar no Twitter",
                "pinIt": "Fixar",
                "downloadImage": "Baixar imagem"
            },
            "is_rtl": false,
            "breakpoints": {
                "xs": 0,
                "sm": 480,
                "md": 768,
                "lg": 1025,
                "xl": 1440,
                "xxl": 1600
            },
            "version": "2.9.8",
            "urls": {
                "assets": "https:\/\/novo.gruporrcosta.com\/conteudos\/plugins\/elementor\/assets\/"
            },
            "settings": {
                "page": [],
                "general": {
                    "elementor_global_image_lightbox": "yes",
                    "elementor_lightbox_enable_counter": "yes",
                    "elementor_lightbox_enable_fullscreen": "yes",
                    "elementor_lightbox_enable_zoom": "yes",
                    "elementor_lightbox_enable_share": "yes",
                    "elementor_lightbox_title_src": "title", 
                    "elementor_lightbox_description_src": "description"
                },
                "editorPreferences": []
            },
            "post": {
                "id": 76,
                "title": "BlueBay%20Camburi%20%E2%80%93%20Uma%20nova%20experi%C3%AAncia%20de%20vida%20urbana%20de%20frente%20para%20o%20mar.",
                "excerpt": "",
                "featuredImage": false
            }
        };
    </script>
    <script type='text/javascript' src='conteudos/plugins/elementor/assets/js/frontend.min4315.js?ver=2.9.8'></script>
    <!-- CUSTOM TYPOGRAPHY STYLES -->
    <script type="text/javascript">
        jQuery.noConflict();
        (function($) {
            $(document).ready(function() {});
        })(jQuery);
    </script>
    <script src="/assets/js/custom.js"></script>
</body>

<!-- Mirrored from novo.gruporrcosta.com/ by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 06 Oct 2020 18:10:26 GMT -->

</html><!-- WP Fastest Cache file was created in 3.51548194885 seconds, on 23-09-20 6:02:53 -->